class PartialRequest {
    #input_data = [] //Ссылка на входные и выходные данные
    #requested_data = [] //Массив ссылок на части input_data
    #current_request_index
    #request_part_number
    #part_size
    #progress_bar_id
    #in_window = true
    #processed = false
    #check_send_process_timeout = 100 // Таймер проверки условий и запроса следующего блока значений
    #current_request_text

    constructor(data, part_size)
    {
        this.#input_data = data
        this.#part_size = part_size
    }

    in_blur()
	{
		this.#in_window = false
        //console.log("pause")
	}

	in_window()
	{
		this.#in_window = true
        //console.log("start")
	}

    add_info_div(div_id)
    {
        this.#progress_bar_id = div_id
    }

    set_input_data(data)
    {
        this.#input_data = data
    }

    async get_values() 
    {
        this.#current_request_index = 0
        this.#request_part_number = 0
        this.#requested_data = []

        await this.request_all()
    }

    request_all() // Процесс запуска запроса очередного блока по условиям по таймеру
    {
        return new Promise((resolve) => 
        {
            const request_processor = () => 
            {
                //console.log("request_processor")
                if (!this.#processed && this.#in_window)
                { 
                    if (this.#current_request_index >= (this.#input_data.length))
                    {
                        console.log("Response received in full")
                        resolve()
                    }
                    else if (this.#input_data != null)
                    {
                        this.request_part()
                        setTimeout(request_processor, this.#check_send_process_timeout)
                    }
                }
                else
                {
                    setTimeout(request_processor, this.#check_send_process_timeout)
                }
            }
    
            request_processor()
        })
    }

    async request_part() {
        //console.log('request_part()')
        let query = ''
        let current_part_index = 0
        this.#requested_data[this.#request_part_number] = []
        this.#processed = true

        if ((this.#input_data.length > 0) && (this.#current_request_index < this.#input_data.length) && (current_part_index < this.#part_size))
        {
            query = '/get_od_data.form?'
            let has_request = false
            for (;;)
            {
                if ((this.#current_request_index >= this.#input_data.length) || (current_part_index >= this.#part_size))
                {
                    break;
                }

                if (this.#input_data[this.#current_request_index] != null)
                {
                    if (this.#input_data[this.#current_request_index].AccessType != null)
                    {
                        if (this.#input_data[this.#current_request_index].AccessType.includes('r')) //read
                        {
                            //if (this.#input_data[this.#current_request_index].index != null)
                            if ((this.#current_request_index > 0) && (current_part_index > 0))
                            {
                                query += "&"
                            }
                            has_request = true
                            query += "0x" + this.#input_data[this.#current_request_index].index.replace(":","_")
                            

                            //let requested_data_index = this.#input_data[this.#current_request_index].index.replace(":","sub")
                            this.#requested_data[this.#request_part_number][current_part_index] = this.#input_data[this.#current_request_index]
                            //console.log(this.#requested_data)

                            current_part_index++
                        }
                    }
                }

                this.#current_request_index++
            }

            if (has_request == false)
            {
                query = ''
            }
            //console.log(query)
            //console.log('current_part_index ' + current_part_index)
        }

        if (this.#progress_bar_id != null)
        {
            utils.get_progress_bar(this.#progress_bar_id, this.#current_request_index, this.#input_data.length)
        }

        return fetch(query)
            .then(response => response.text())
            .then(text => {
                this.#current_request_text = text
                return utils.response_ready(text)
            })
            .then(values =>  {
                if (values.length != this.#requested_data[this.#request_part_number].length)
                {
                    alert(`${l100n.localize_string("response error")} index: ${this.#requested_data[this.#request_part_number][0].index} size: ${this.#part_size} request_text: ${this.#current_request_text}`)
                    //Ответ может приходить не полностью если длинна превышает определенное значение
                    console.log(this.#requested_data[this.#request_part_number][0].index)
                    console.log(this.#current_request_text)
                    console.log(values)
                }

                
                let buf = this.#requested_data[this.#request_part_number]
                $.each(values, function(index, item)
                {
                    buf[index].DefaultValue = item
                })
                this.#request_part_number += 1

                this.#processed = false
            })
    }    
}
